<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class DevicesTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('device');
		$this->setPrimaryKey('id');
	}

	public function getDetails(int $id): array
	{
		$record = $this->find()
			->where(['id' => $id])
			->first();

		return $record ? $record->toArray() : [];
	}

	public function ifExist(string $name): array
	{
		$record = $this->find()
			->where(['key' => $name])
			->first();

		return $record ? $record->toArray() : [];
	}
}
