<?php
declare(strict_types=1);

namespace App\Model;

use Cake\ORM\Table;

class StripeAppModel extends Table
{
	protected string $_defaultConnection = 'stripe';

	public function initialize(array $config): void
	{
		parent::initialize($config);
		$this->setTable(false);
	}

	public function getStripeError(): string
	{
		$connection = $this->getConnection();
		return $connection->getDriver()->getLastError() ?? '';
	}
}
