<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\ORM\Query;
use Cake\Datasource\EntityInterface;
use Cake\Datasource\ResultSetInterface;

class StickerUsedsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('sticker_used');

		$this->belongsTo('Stickers', [
			'foreignKey' => 'sticker_id',
			'className' => 'App\Model\Table\StickersTable',
		]);

		$this->belongsTo('Users', [
			'foreignKey' => 'visitor_id',
			'className' => 'App\Model\Table\UsersTable',
		]);

		$this->belongsTo('ProfileVisits', [
			'foreignKey' => 'visitor_id',
			'bindingKey' => 'visitor_id',
			'joinType' => 'INNER',
			'className' => 'App\Model\Table\ProfileVisitsTable',
		]);
	}

	public function getDetails(int $id): ?EntityInterface
	{
		return $this->find()
			->where(['StickerUsed.id' => $id])
			->contain(['Stickers', 'Users'])
			->first();
	}

	public function getAll(string $type, int $starting_point): ResultSetInterface
	{
		return $this->find()
			->matching('Stickers', function (Query $q) use ($type) {
				return $q->where(['Stickers.type' => $type]);
			})
			->group('ProfileVisits.visitor_id')
			->limit(10)
			->offset($starting_point * 10)
			->all();
	}

	public function getProfileVisitorsUnreadCount(int $user_id): int
	{
		return $this->getAssociation('ProfileVisits')->getTarget()->find()
			->where([
				'ProfileVisits.user_id' => $user_id,
				'ProfileVisits.read' => 0
			])
			->group('ProfileVisits.visitor_id')
			->count();
	}

	public function updateReadCount(int $user_id): void
	{
		$this->getAssociation('ProfileVisits')->getTarget()->updateAll(
			['read' => 1],
			['user_id' => $user_id]
		);
	}
}
