<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class PayoutsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('payout');
		$this->setPrimaryKey('id');

		$this->belongsTo('User', [
			'foreignKey' => 'user_id'
		]);
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['Payout.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function ifExist(int $user_id): array
	{
		$result = $this->find()
			->where(['Payout.user_id' => $user_id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function getUserCards(int $user_id): array
	{
		// Assuming `Payout` is being used for cards (adjust if incorrect)
		return $this->find()
			->select(['stripe', 'id'])
			->where(['Payout.user_id' => $user_id])
			->toArray();
	}
}
?>
