<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class ProductAttributesTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('product_attribute');
		$this->setPrimaryKey('id');

		$this->belongsTo('Product', [
			'foreignKey' => 'product_id'
		]);

		$this->hasMany('ProductAttributeVariation', [
			'foreignKey' => 'product_attribute_id',
			'dependent' => true
		]);
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['ProductAttribute.id' => $id])
			->contain(['ProductAttributeVariation'])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function ifExist(array $data): array
	{
		$result = $this->find()
			->where([
				'ProductAttribute.id' => $data['name'],
				'ProductAttribute.product_id' => $data['product_id']
			])
			->first();

		return $result ? $result->toArray() : [];
	}
}
?>
