<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\ORM\Query;

class RoomMembersTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('room_member');
		$this->setPrimaryKey('id');

		$this->belongsTo('Room', [
			'foreignKey' => 'room_id'
		]);

		$this->belongsTo('User', [
			'foreignKey' => 'user_id'
		]);
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['RoomMember.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function getUserRooms(int $user_id): array
	{
		return $this->find()
			->where(['RoomMember.user_id' => $user_id])
			->toArray();
	}

	public function getRoomModerators(int $room_id): array
	{
		return $this->find()
			->where([
				'RoomMember.room_id' => $room_id,
				'RoomMember.moderator !=' => 0
			])
			->contain(['User'])
			->toArray();
	}

	public function getRoomMembers(int $room_id): array
	{
		return $this->find()
			->where(['RoomMember.room_id' => $room_id])
			->toArray();
	}

	public function getRecentListeners(int $user_id, int $starting_point): array
	{
		return $this->find()
			->where([
				'RoomMember.user_id !=' => $user_id,
				'RoomMember.moderator IN' => [1, 2]
			])
			->limit(10)
			->offset($starting_point * 10)
			->toArray();
	}

	public function getMembersCount(int $room_id): int
	{
		return $this->find()
			->where(['RoomMember.room_id' => $room_id])
			->count();
	}

	public function ifExist(int $room_id, int $user_id): ?array
	{
		$result = $this->find()
			->where([
				'RoomMember.user_id' => $user_id,
				'RoomMember.room_id' => $room_id
			])
			->first();

		return $result ? $result->toArray() : null;
	}

	public function getAll(): array
	{
		return $this->find()->toArray();
	}
}
?>
