<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class HtmlPagesTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('html_page');
		$this->setPrimaryKey('id');
	}

	public function getDetails(int $id): array
	{
		$record = $this->find()
			->where(['id' => $id])
			->first();

		return $record ? $record->toArray() : [];
	}

	public function getAllPages(): array
	{
		return $this->find()
			->all()
			->toList();
	}

	public function ifExist(string $name): array
	{
		$record = $this->find()
			->where(['name' => $name])
			->first();

		return $record ? $record->toArray() : [];
	}
}
