<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class NotInterestedVideosTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('not_interested_video');
		$this->setPrimaryKey('id');

		$this->belongsTo('Users', [
			'foreignKey' => 'user_id',
			'className' => 'App\Model\Table\UsersTable',
		]);

		$this->belongsTo('Videos', [
			'foreignKey' => 'video_id',
			'className' => 'App\Model\Table\VideosTable',
		]);
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['NotInterestedVideo.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function checkDuplicate(int $user_id, int $video_id): int
	{
		return $this->find()
			->where([
				'NotInterestedVideo.video_id' => $video_id,
				'NotInterestedVideo.user_id' => $user_id
			])
			->count();
	}
}
