<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class NotificationsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('notification');
		$this->setPrimaryKey('id');

		$this->belongsTo('Video', [
			'foreignKey' => 'video_id'
		]);

		$this->belongsTo('Sender', [
			'className' => 'User',
			'foreignKey' => 'sender_id'
		]);

		$this->belongsTo('Receiver', [
			'className' => 'User',
			'foreignKey' => 'receiver_id'
		]);

		$this->belongsTo('Order', [
			'foreignKey' => 'order_id'
		]);
	}

	public function getDetails(int $id): array
	{
		$result = $this->find()
			->where(['Notification.id' => $id])
			->first();

		return $result ? $result->toArray() : [];
	}

	public function ifStreamingNotificationExist(int $sender_id, int $receiver_id, int $streaming_id): int
	{
		return $this->find()
			->where([
				'Notification.sender_id' => $sender_id,
				'Notification.receiver_id' => $receiver_id,
				'Notification.live_streaming_id' => $streaming_id
			])
			->count();
	}

	public function getAll(): array
	{
		return $this->find()->toArray();
	}

	public function getUserNotifications(int $user_id, int $starting_point): array
	{
		return $this->find()
			->contain(['Sender', 'Receiver'])
			->where([
				'Notification.receiver_id' => $user_id,
				'Sender.id >' => 0
			])
			->order(['Notification.id' => 'DESC'])
			->limit(20)
			->offset($starting_point * 20)
			->toArray();
	}

	public function getVideoNotifications(): array
	{
		return $this->find()
			->where([
				'Notification.video_id >' => 0,
				'Video.id >' => 0
			])
			->order(['Notification.id' => 'DESC'])
			->toArray();
	}

	public function getUserUnreadNotification(int $user_id): int
	{
		return $this->find()
			->where([
				'Notification.receiver_id' => $user_id,
				'Notification.read' => 0
			])
			->count();
	}

	public function readNotification(int $user_id): void
	{
		$this->updateAll(
			['read' => 1],
			['receiver_id' => $user_id]
		);
	}
}
?>
