<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class ReportUsersTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('report_user');
		$this->setPrimaryKey('id');

		$this->belongsTo('User', [
			'foreignKey' => 'user_id'
		]);

		$this->belongsTo('Report', [
			'className' => 'User',
			'foreignKey' => 'report_user_id'
		]);

		$this->belongsTo('ReportReason', [
			'foreignKey' => 'report_reason_id'
		]);
	}

	public function getDetails(int $id): ?array
	{
		$result = $this->find()
			->where(['ReportUser.id' => $id])
			->first();

		return $result ? $result->toArray() : null;
	}

	public function getReportsAgainstUser(int $user_id): ?array
	{
		$result = $this->find()
			->where(['ReportUser.report_user_id' => $user_id])
			->first();

		return $result ? $result->toArray() : null;
	}

	public function getAll(): array
	{
		return $this->find()
			->order(['ReportUser.id' => 'DESC'])
			->toArray();
	}
}
?>
