<?php
declare(strict_types=1);

ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

if (!defined('DS')) {
    define('DS', DIRECTORY_SEPARATOR);
}
if (!defined('ROOT')) {
    define('ROOT', dirname(__DIR__));
}
if (!defined('LOGS')) {
    define('LOGS', ROOT . DS . 'logs' . DS);
}

use Cake\Cache\Cache;
use Cake\Core\Configure;
use Cake\Core\Plugin;
use Cake\Log\Log;

// Set default cache configuration
Cache::setConfig('default', [
    'className' => 'File',
]);

// Set language handling preferences
Configure::write('I18n.preferApp', true);

// Configure logging
Log::setConfig('debug', [
    'className' => 'File',
    'path' => LOGS,
    'file' => 'debug',
    'levels' => ['notice', 'info', 'debug'],
]);

Log::setConfig('error', [
    'className' => 'File',
    'path' => LOGS,
    'file' => 'error',
    'levels' => ['warning', 'error', 'critical', 'alert', 'emergency'],
]);

// Plugin loading is now handled in src/Application.php in CakePHP 4.x