<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class InterestsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('interest');
		$this->setPrimaryKey('id');
	}

	public function getDetails(int $id): array
	{
		$record = $this->find()
			->where(['id' => $id])
			->first();

		return $record ? $record->toArray() : [];
	}

	public function getRandomInterestIDs(): array
	{
		$rand = random_int(3, 8);

		return $this->find()
			->order('RAND()')
			->limit($rand)
			->all()
			->toList();
	}

	public function ifExist(string $title): array
	{
		$record = $this->find()
			->where(['title' => $title])
			->first();

		return $record ? $record->toArray() : [];
	}

	public function getInterestsAgainstSection(int $section_id): array
	{
		return $this->find()
			->where(['interest_section_id' => $section_id])
			->orderAsc('order')
			->all()
			->toList();
	}

	public function getAll(): array
	{
		return $this->find()
			->orderDesc('featured')
			->all()
			->toList();
	}
}
