<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\ORM\Query;
use Cake\Datasource\EntityInterface;

class SoundSectionsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('sound_section');
		$this->setPrimaryKey('id');
		$this->hasMany('Sound', [
			'foreignKey' => 'sound_section_id',
			'dependent' => true
		]);
		$this->addBehavior('Containable');
	}

	public function getDetails(int $id): array
	{
		$query = $this->find()
			->where(['SoundSection.id' => $id])
			->limit(1);

		return $query->firstOrFail()->toArray();
	}

	public function ifExist(string $name): array
	{
		$query = $this->find()
			->where(['SoundSection.name' => $name])
			->limit(1);

		$result = $query->first();
		return $result ? $result->toArray() : [];
	}

	public function getAll(): array
	{
		$query = $this->find()
			->contain([
				'Sound' => function (Query $q) {
					return $q->limit(3);
				}
			]);

		return $query->toArray();
	}
}
?>
