<?php

declare(strict_types=1);

namespace Kreait\Firebase\Value;

use JsonSerializable;
use Kreait\Firebase\Exception\InvalidArgumentException;

use function mb_strlen;

/**
 * @internal
 */
final class Uid implements JsonSerializable
{
    private string $value;

    public function __construct(string $value)
    {
        if ($value === '' || mb_strlen($value) > 128) {
            throw new InvalidArgumentException('A uid must be a non-empty string with at most 128 characters.');
        }

        $this->value = $value;
    }

    public function __toString()
    {
        return $this->value;
    }

    public function jsonSerialize(): string
    {
        return $this->value;
    }

    /**
     * @param self|string $other
     */
    public function equalsTo($other): bool
    {
        return $this->value === (string) $other;
    }
}
