<?php

declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;

class CouponUsedsTable extends Table
{
	public function initialize(array $config): void
	{
		parent::initialize($config);

		$this->setTable('coupon_used');
		$this->setPrimaryKey('id');

		$this->belongsTo('Orders', [
			'className' => 'App\Model\Table\OrdersTable',
			'foreignKey' => 'order_id',
		]);
	}

	public function ifCouponCodeUsedByUser(int $couponId, int $userId): int
	{
		return $this->find()
			->where([
				'coupon_id' => $couponId,
				'user_id' => $userId,
			])
			->count();
	}

	public function countCouponUsed(int $couponId): int
	{
		return $this->find()
			->where([
				'coupon_id' => $couponId,
			])
			->count();
	}
}
